<?php
/*--------------------------------------------------------------------------------------------------
    PropertyGroupReader.php 2020-02-17
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */
declare(strict_types=1);

namespace Gambio\Shop\Properties\ProductModifiers\Database\Readers;

use CI_DB_query_builder;
use Gambio\Shop\ProductModifiers\Database\Core\DTO\Groups\GroupDTOBuilderInterface;
use Gambio\Shop\ProductModifiers\Database\Core\DTO\Groups\GroupDTOCollection;
use Gambio\Shop\ProductModifiers\Database\Core\DTO\Groups\GroupDTOCollectionInterface;
use Gambio\Shop\ProductModifiers\Database\Core\Readers\Interfaces\GroupReaderCompositeInterface;
use Gambio\Shop\Properties\ProductModifiers\Database\ValueObjects\PropertyGroupIdentifier;
use Gambio\Shop\Product\ValueObjects\ProductId;
use IdType;

/**
 * Class PropertyGroupReader
 * @package Gambio\Shop\Properties\ProductModifiers\Database\Readers
 */
class PropertyGroupReader implements GroupReaderCompositeInterface
{
    
    /**
     * @var GroupDTOBuilderInterface
     */
    protected $builder;
    /**
     * @var CI_DB_query_builder
     */
    protected $queryBuilder;
    
    
    /**
     * PropertyGroupReader constructor.
     *
     * @param CI_DB_query_builder      $queryBuilder
     * @param GroupDTOBuilderInterface $builder
     */
    public function __construct(CI_DB_query_builder $queryBuilder, GroupDTOBuilderInterface $builder)
    {
        $this->queryBuilder = $queryBuilder;
        $this->builder      = $builder;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getGroupsByProduct(
        ProductId $id,
        IdType $languageId
    ): GroupDTOCollectionInterface {
        $result = new GroupDTOCollection();
        
        $sql = "SELECT p.properties_id, pd.properties_name, p.display_type
                    FROM properties p
                        INNER JOIN products_properties_combis ppc on ppc.products_id = {$id->value()}
                        INNER JOIN products_properties_combis_values ppcv on ppc.products_properties_combis_id = ppcv.products_properties_combis_id
                        INNER JOIN properties_values pv on pv.properties_values_id = ppcv.properties_values_id AND pv.properties_id = p.properties_id
                        INNER JOIN properties_description pd on p.properties_id = pd.properties_id AND pd.language_id = {$languageId->asInt()}
                    GROUP BY p.properties_id, pd.properties_name, p.display_type;";
        
        $data = $this->queryBuilder->query($sql)->result_array();
        
        foreach ($data as $item) {
            $result->addGroup($this->builder->withId(new PropertyGroupIdentifier((int)$item['properties_id']))
                                            ->withName($item['properties_name'])
                                            ->withType($item['display_type'])
                                            ->withSource('property')
                                            ->build());
        }
        
        return $result;
    }
}